# Forums Earl Haig — Visual Assets & Banner Prompts

Dokumen ini berisi konsep logo, favicon, dan prompt untuk menghasilkan gambar banner HD yang siap diganti dari placeholder SVG.

---

## 1. Logo (PNG Transparan HD)

**Konsep:** "Forums Earl Haig" — emblem akademik bersih, tidak terlihat AI-generated.

- **Elemen:** Huruf "F" stylized + ikon forum (dua bubble diskusi) dalam satu unit. Teks "Forums" (font serif tebal) + "Earl Haig" (subtitle lebih kecil). Warna: academic blue (#1e3a5f ke #2c5282).
- **Gaya:** Vector clean, minimalis, emblem-style. Cocok untuk header putih.
- **Format:** PNG transparan, tinggi minimal 96px (atau 192px untuk retina).
- **Referensi file:** `assets/img/logo.svg` — ekspor ke PNG dari SVG atau buat ulang sesuai konsep di atas.

**Prompt untuk generator gambar (jika buat dari nol):**  
*"Minimalist academic logo for 'Forums Earl Haig': letter F combined with two speech bubbles icon, serif wordmark 'Forums' and smaller 'Earl Haig' below. Navy blue (#1e3a5f), clean vector style, transparent background, no 3D effects, professional Canadian school forum branding."*

---

## 2. Favicon (HD)

**Konsep:** Simbol huruf "F" dan inisial "EH" minimalis, bersih.

- **Elemen:** Kotak rounded (6px radius), background #1e3a5f, huruf "F" putih di tengah. Opsional: titik kecil (circle) mewakili forum bubble.
- **Ukuran:** 512×512 (Apple touch / HD) dan 32×32 (browser).
- **Format:** PNG (32x32 dan 512x512). SVG sudah disediakan di `assets/img/favicon.svg`.

**Prompt untuk favicon:**  
*"Favicon for Forums Earl Haig: square with rounded corners, navy blue background, white letter F in center, minimal serif or sans serif, one small circle accent. Clean, professional. 512x512 and 32x32 PNG, transparent or same blue background."*

---

## 3. Banner Homepage (HD)

**File target:** Ganti `assets/img/banner-home.svg` dengan gambar HD (mis. `banner-home.jpg` atau `.webp`). Update referensi di `index.html`.

**Prompt:**  
*"Modern academic community discussion forum banner, Canadian high school setting. Diverse students in casual conversation in a bright, clean campus common area or library. Soft natural lighting, warm but professional. No text overlay. HD, 1920x720, photorealistic, not cartoon. Trust-based, inclusive atmosphere."*

---

## 4. Banner per Subfolder (HD)

Setiap banner 1920×480 (atau 1920×720 jika konsisten dengan homepage). Ganti file SVG di masing-masing folder dengan JPG/WebP dan update path di `index.html` subfolder.

| Subfolder | Nama file disarankan | Prompt |
|-----------|----------------------|--------|
| **General Discussion** | `general-discussion/banner.jpg` atau pakai `../assets/img/banner-general.svg` → ganti dengan `banner-general.jpg` | *"Open discussion atmosphere: group of people in casual conversation in a modern, bright space. Neutral background, soft shadows. Academic but relaxed. HD 1920x480, clean lighting, no text."* |
| **Academic Support** | `assets/img/banner-academic.jpg` | *"Academic support and study environment: students at desks or with laptops, books, collaborative learning. Clean classroom or study room, natural light. Canadian school feel. HD 1920x480, professional, no text."* |
| **Student Life** | `assets/img/banner-student.jpg` | *"Student life on campus: diverse students walking or chatting outdoors, campus building in background. Bright day, green space or courtyard. Lively but orderly. HD 1920x480, natural, no text."* |
| **Events & Updates** | `assets/img/banner-events.jpg` | *"Community events and updates: small stage or gathering space, audience or participants, event atmosphere. Modern venue, good lighting. HD 1920x480, professional event vibe, no text."* |
| **Resources & Sharing** | `assets/img/banner-resources.jpg` | *"Resources and document sharing: hands with papers or tablet, shared notes, clean desk. Focus on collaboration and learning materials. Soft lighting. HD 1920x480, no text."* |
| **Alumni Network** | `assets/img/banner-alumni.jpg` | *"Alumni and professional network: professionals in business casual, handshake or networking moment. Modern office or conference setting. Trust and connection. HD 1920x480, no text."* |

---

## 5. Update HTML setelah ganti banner

Setelah Anda punya file JPG/WebP:

1. **Homepage** (`index.html`): ganti  
   `assets/img/banner-home.svg` → `assets/img/banner-home.jpg`  
   dan sesuaikan `og:image` / `twitter:image` ke URL akhir.

2. **Subfolder:** di setiap `index.html` subfolder, ganti mis.  
   `../assets/img/banner-general.svg` → `../assets/img/banner-general.jpg`  
   (atau simpan banner di dalam subfolder, mis. `general-discussion/banner.jpg`, lalu path = `banner.jpg`).

3. **Schema `image`:** di JSON-LD Article setiap subfolder, update `"image"` ke URL absolut gambar baru (mis. `https://forums.earlhaig.ca/assets/img/banner-general.jpg`).

---

## 6. Ringkasan file aset saat ini

| Aset | Path | Status |
|------|------|--------|
| Logo | `assets/img/logo.svg` | Vector siap; ekspor PNG untuk production |
| Favicon | `assets/img/favicon.svg` | Vector siap; ekspor 32×32 dan 512×512 PNG |
| Banner home | `assets/img/banner-home.svg` | Placeholder; ganti dengan HD image + update HTML |
| Banner general | `assets/img/banner-general.svg` | Placeholder |
| Banner academic | `assets/img/banner-academic.svg` | Placeholder |
| Banner student | `assets/img/banner-student.svg` | Placeholder |
| Banner events | `assets/img/banner-events.svg` | Placeholder |
| Banner resources | `assets/img/banner-resources.svg` | Placeholder |
| Banner alumni | `assets/img/banner-alumni.svg` | Placeholder |

Semua struktur siap deploy. Ganti SVG banner dengan gambar HD sesuai prompt di atas lalu update path dan schema image di HTML.
